unit EngineImportDlg01;
(*
   ========================================================================
    " " GraphEngine.
          .
   ========================================================================
    :
   1)      R, G, B
   2)    Image   .
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)
interface

uses
     //  
     Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, ExtCtrls, Dialogs, StrUtils, ComCtrls,
     //  GraphEngine
     EngineMainData01, EngineImgService01,
     //  
     MainData;

// ========================================================================
//   
// ========================================================================
type
  TImportTxtDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    RadioGroup1: TRadioGroup;
    EditSep: TEdit;
    Label1: TLabel;
    ProgressBar1: TProgressBar;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
    //   
    procedure ImportTxtToImgTabBGR(ptITabBGR    : ptImgTabBGR;
                                   RqOpenDialog : TOpenDialog);
  public
    { Public declarations }
  end;
// ========================================================================
//  
// ========================================================================
var
  ImportTxtDialog: TImportTxtDialog;   //    

// ========================================================================
implementation
{$R *.dfm}
// ========================================================================

// ========================================================================
//    
// ========================================================================
//  27.10.2008.
//   
procedure TImportTxtDialog.ImportTxtToImgTabBGR(ptITabBGR    : ptImgTabBGR;
                                            RqOpenDialog : TOpenDialog);
var FullFileName, WSep : string;
begin
  OpenDialog1.Filter:='Image text format files (*.txt)|*.txt';
  if OpenDialog1.Execute
  then begin
     //      txt - 
     FullFileName := OpenDialog1.FileName;
     //      
     Self.Repaint;
     if FullFileName <> ''
     then begin
        //   
        case RadioGroup1.ItemIndex of
        0 : WSep := #09;  // 
        1 : WSep := ';';
        2 : begin
            WSep := EditSep.Text;
            WSep := LeftStr(Trim(WSep),1);
            end;
            else WSep := ';';
         end; // of case
         //  
         TxtToImgTabBGR (ptITabBGR,
                         WSep, FullFileName,
                         ProgressBar1);
     end;
  end;
end; // of procedure

// ========================================================================
//     
// ========================================================================
// 27.10.2008.
procedure TImportTxtDialog.CancelBtnClick(Sender: TObject);
begin
  //     
  Self.Close;
end;
// ------------------------------------------------------------------------
// 27.10.2008.
procedure TImportTxtDialog.OKBtnClick(Sender: TObject);
begin
  //  
  // !
  //     
  // Addr(.....)   TImgTabBGR   MainData.
  //      ImportDialog01
  ImportTxtToImgTabBGR(Addr(SrcImgTabBGR), OpenDialog1);
  //     
  Self.Close;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
